%% Norm-preserving action
% input: 
% q: function
% t: time points on [0,1]
% gam: phase function
% output: transformed function
function q_out = qComposeGamma(q,t,gam)
T = length(gam);
gam(end) = 1;
s_gam_dot = sqrt(gradient(gam, 1/(T-1)));
q_out = (interp1(t,q,gam,'linear').*s_gam_dot)';
end