# simulate curves from warpMix model, three different fixed effect functions
library(fda)
library(MASS)
library(warpMix)
source("./Functions/warpMixCurves.R")
set.seed(1)
T = 50
n = 30
t = seq(0,1,length.out = T)
# fixed effect functions
mu1 = (sin(3*pi*t)+3*pi*t)/4
mu2 = exp(-(t-0.25)^2/0.04) + exp(-(t-0.75)^2/0.02)
mu3 = cos(2*pi*t+pi/2)
# simulate curves
warpMixCurves(n,T,mu1,1)
warpMixCurves(n,T,mu2,2)
warpMixCurves(n,T,mu3,3)


