# impletment warpMix algorithm on Berkeley growth velocity data
library(fda)
library(MASS)
library(warpMix)
female <- read.table("./data/growth_female_vel.txt")
male <- read.table("./data/growth_male_vel.txt")
Y <- as.matrix(cbind(female, male))
t <- seq(0,1, length.out = nrow(Y))
baseMu = create.bspline.basis(c(0,max(t)), norder = 3, breaks = seq(0,1,length.out = 5))
baseU = create.bspline.basis(c(0,max(t)),norder = 3, breaks = seq(0,1,length.out = 5))
baseW = create.bspline.basis(c(0,max(t)), norder = 2, breaks = c(0,0.6,1))
result_BG <- warpMix(t,Y,baseMu, baseU, baseW, nIte = 10)
est_coef_main <- result_BG$parameters$alphaMu
splineBasisMu = eval.basis(t,baseMu)
plot(t,splineBasisMu%*%est_coef_main,
     ylab = "Values",
     main = "Estimated main effect for Berkeley Growth Data",
     type = "l")
mu_est <- splineBasisMu%*%est_coef_main
write.table(mu_est,"./result/warpMixBG.csv",row.names = F,col.names = F)