# implement warpMix algorithm on data simulated from Prior Model 1 and Prior Model2
library(fda)
library(MASS)
library(warpMix)
library(R.matlab)

T = 50
n = 30
t = seq(0,1,length.out = T)
# basis
baseMu = create.bspline.basis(c(0,max(t)), norder = 3, breaks = seq(0,1,length.out = 5))
baseU = create.bspline.basis(c(0,max(t)),norder = 3, breaks = seq(0,1,length.out = 5))
baseW = create.bspline.basis(c(0,max(t)), norder = 5, breaks = c(0,0.6,1))
splineBasisMu = eval.basis(t,baseMu)
# load data
data1 <- readMat("./data/SimCurvePriorModel1_sigma_0.1_main_Fourier_random_BSpline_basisSize_m_6_basisSize_v_6_T_50.mat")
data1 <- data1$qt
data1 <- do.call(rbind, data1)
Y <- t(do.call(rbind, data1))
timestart = Sys.time()
result_mu1 <- warpMix(t,Y,baseMu, baseU, baseW, nIte = 10)
est_coef_main <- result_mu1$parameters$alphaMu
mu_est <- splineBasisMu%*%est_coef_main
timeend = Sys.time()
timespend = timeend - timestart
print(paste("warpMix run time on data simulated from Prior Model 1: ",round(timespend,2), " minitues", sep = ""))
write.table(mu_est,"./result/warpMixSimDataPriorModel1.csv",row.names = F,col.names = F)
data2 <- readMat("./data/SimCurvePriorModel2_sigma_0.1_main_Fourier_random_BSpline_basisSize_m_6_basisSize_v_6_T_50_nG_5_thetag_30.mat")
data2 <- data2$qt
data2 <- do.call(rbind, data2)
Y <- t(do.call(rbind, data2))
timestart = Sys.time()
result_mu2 <- warpMix(t,Y,baseMu, baseU, baseW, nIte = 10)
est_coef_main <- result_mu2$parameters$alphaMu
mu_est <- splineBasisMu%*%est_coef_main
timeend = Sys.time()
timespend = timeend - timestart
print(paste("warpMix run time on data simulated from Prior Model 2: ",round(timespend,2), " minitues", sep = ""))
write.table(mu_est,"./result/warpMixSimDataPriorModel2.csv",row.names = F,col.names = F)