## CodePlan

### 1. Install 

```bash
conda create -n codeplan python=3.10
pip install -r requirements.txt
```

### 2. Generate Code-form Plan Annotations
```bash
python gen.py
```

### 3. Training
```bash
MAX_EPOCH=2
CKPT_NAME=Mistral-7B-v0.3
CKPT_PATH=XXX

LR=5e-6
BC=16
GRAD_ACC=1
WM=0.03
MAX_LEN=2048
DEEPSPEED=ds_config_zero2_bf16.json


TRAIN_DATA=mamooth2

EXP_NAME=XXX
SAVE_DIR=XXX

LOGGING_DIR=results/$CKPT_NAME/$EXP_NAME


cmd="deepspeed --master_port 29508 train.py \
    --run_name $EXP_NAME \
    --deepspeed_config $DEEPSPEED \
    --train_data $TRAIN_DATA \
    --val_data $VAL_DATA \
    --output_dir $SAVE_DIR \
    --logging_dir $LOGGING_DIR \
    --max_len $MAX_LEN \
    --lr $LR \
    --warmup $WM \
    --batch_size $BC \
    --max_epochs $MAX_EPOCH \
    --ckpt_path $CKPT_PATH\
    --tokenizer_path XXX \
    --gradient_accumulation $GRAD_ACC \
    --flash_attn \
    --save_steps 1000 \
    --loss sft_loss \
    --plan plan"

echo $cmd
$cmd | tee log.txt
```