class EvalMetric:

    def get_name(self):

        if hasattr(self, "name"):
            return self.name
        return self.__class__.__name__

    def __init__(self, is_retrain_standard=True):

        self.clear_results()
        self.is_retrain_standard = is_retrain_standard

    def clear_results(self):

        self.results = {}
        self.clear_buffer()

    def clear_buffer(self):
        self.buffer = {}

    def pre_process(self, *args, **kwargs):
        pass

    def evaluate(self, model, loaders, iteration):

        raise NotImplementedError("eval() must be implemented")

    def finalize(self, buffer, name, retrain_buffer=None):

        return buffer

    def post_process(self, name, iteration, model, loaders):
        
        self.buffer[(name, iteration)] = self.evaluate(model, loaders, iteration)

    def calculate(self):

        for name, iteration in self.buffer:
            if self.is_retrain_standard:
                self.results[(name, iteration)] = self.finalize(
                    self.buffer[(name, iteration)],
                    name + "_" + str(iteration),
                    retrain_buffer=self.buffer[("Retrain", iteration)],
                )
            else:
                self.results[(name, iteration)] = self.finalize(
                    self.buffer[(name, iteration)],
                    name + "_" + str(iteration),
                )

    def get_results(self):

        return self.results