## Dataset
We provide the processed ABIDE-I dataset online at [here](https://drive.google.com/file/d/12aKVBBb5vtDxU6G-SniifG6RFVzWax0P/view?usp=sharing)

The raw datasets are publicly online at [ABIDE](https://fcon_1000.projects.nitrc.org/indi/abide/), [ADHD-200](http://fcon_1000.projects.nitrc.org/indi/adhd200/index.html), [REST-MDD](http://rfmri.org/REST-meta-MDD).

## Preprocessing
We use the C-PAC for pipeline, which is available at [here](https://github.com/FCP-INDI/C-PAC).

## usage

1. change the /path/to/data
2. run with configs

```bash
python -m torch.distributed.launch --nproc_per_node=4 --master_port=12345 01-ddp_train.py --config configs/aug/abide_mask_num40.yaml;
```

More details can be modified in the corresponding config files. (./configs)

03-eval_example.py provides an example for classification tasks.

## Installation
scikit-learn\
pandas\
timm==0.6.7\
cudatoolkit=11.3\
torch==1.13.1+cu117


## TODO
Other running logs and checkpoints are still in preparation.