
# GenCorres Implicit Generator

This readme shows the details of training the implicit generator of GenCorres on the subsampled THUman dataset. The details are in the supplementary material.

## Create the dataset.

### Download and preprocess the dataset.
Download the THUman dataset from: https://github.com/ZhengZerong/DeepHuman/tree/master/THUmanDataset

After unzipping the dataset, change the data path of THUman dataset in Line 51 of `./data/thuman/generate_date_align.py`

Then
```
cd data/thuman
python generate_date_align.py
```
The raw aligned mesh is saved in the folder `./registrations128/thuman/pose/`.

### Generate the SDF values.
```
python preprocess.py --datapath ./ --human thuman --pose pose
```
The SDF data is saved in the folder `./registrations128_processed_sal_sigma02`.


### Train the network
```
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 bash scripts/dist_train.sh 8 --config ./config/asap/ivae_2C64_L64_GL01_1B4_ASAP_8B4.yaml --mode train --rep sdf
```

### Interpolation
```
CUDA_VISIBLE_DEVICES=0 python main.py --config ./config/asap/ivae_2C64_L64_GL01_1B4_ASAP_8B4.yaml --mode interp --rep sdf --split train --continue_from 7999 --interp_src_fid thuman-pose-results_gyx_20181015_hzx_2_M_8128 --interp_tgt_fid thuman-pose-results_gyx_20181015_lyx_1_F_14760
```





