import numpy as np


class Soft:
    def __init__(self, answers, n_classes, **kwargs):
        self.answers = answers
        self.n_classes = n_classes

    def get_answers(self):
        baseline = np.zeros((len(self.answers), self.n_classes))
        for task_id in list(self.answers.keys()):
            task = self.answers[task_id]
            for vote in list(task.values()):
                baseline[int(task_id), int(vote)] += 1
        self.baseline = baseline
        return baseline / baseline.sum(axis=1).reshape(-1, 1)
