#!/bin/bash

python -m venv venv
source venv/bin/activate
pip install --upgrade --no-cache-dir pip

echo "Installing dependencies..."
pip install --upgrade --no-cache-dir pip setuptools
pip install --no-cache-dir ninja packaging psutil wheel appdirs>=1.4.4 fire>=0.6.0 \
    multipledispatch>=0.6.0 pqdm>=0.2.0 tempdir>=0.7.1 termcolor>=2.0.0 tqdm>=4.56.0 \
    tree_sitter_languages>=1.10.2 tree-sitter==0.21.3 wget
pip install --no-cache-dir torch==2.6.0 torchvision torchaudio --index-url https://download.pytorch.org/whl/cu126
pip install --no-cache-dir causal-conv1d triton==3.2.0
pip install --no-cache-dir matplotlib tensorboard einops
pip install --no-cache-dir tqdm accelerate==1.3.0 transformers==4.49.0 datasets==3.3.2 pandas deepspeed

echo "Installing flash-attention..."
MAX_JOBS=10 pip install --no-cache-dir -U flash-attn==2.7.4.post1 --no-build-isolation

git clone https://github.com/HazyResearch/flash-attention flash-attention \
    && cd flash-attention && git checkout v2.7.4.post1 \
    && printf "[safe]\n\tdirectory = /flash-attention" > ~/.gitconfig \
    && git config --global --add safe.directory flash-attention
cd csrc/fused_softmax && pip install . && cd ../../   \
    && cd csrc/rotary && pip install . && cd ../../   \
    && cd csrc/xentropy && pip install . && cd ../../   \
    && cd csrc/fused_dense_lib && pip install . && cd ../../   \
    && cd csrc/ft_attention && pip install . && cd ../../   \
    && cd csrc/layer_norm && pip install . && cd ../../

echo "Successfully installed flash-attention 0.7.4 and pytorch 2.6"
