
# our prompt generator
def generate_COT(subsql,question, evidence):

    subsql_content = "\n".join(subsql)

    content = f"""Generate a chain of thought (CoT) reasoning process that explains how each sub-SQL query incrementally builds towards answering the original question. Ensure the reasoning is clear, concise, and logically follows the progression of the sub-SQLs.

Example:
question: What is the average writing score of each of the schools managed by Ricci Ulrich? List the schools and the corresponding average writing scores.
evidence: Usually, administrators manage the school stuff.;
subsql list: 
SELECT * FROM satscores
SELECT * FROM satscores INNER JOIN schools ON satscores.cds = schools.cdscode
SELECT * FROM satscores INNER JOIN schools ON satscores.cds = schools.cdscode WHERE schools.admlname1 = 'Ulrich'
SELECT * FROM satscores INNER JOIN schools ON satscores.cds = schools.cdscode WHERE schools.admfname1 = 'Ricci' AND schools.admlname1 = 'Ulrich'
SELECT satscores.avgscrwrite FROM satscores INNER JOIN schools ON satscores.cds = schools.cdscode WHERE schools.admfname1 = 'Ricci' AND schools.admlname1 = 'Ulrich'
SELECT schools.school, satscores.avgscrwrite FROM satscores INNER JOIN schools ON satscores.cds = schools.cdscode WHERE schools.admfname1 = 'Ricci' AND schools.admlname1 = 'Ulrich'
Now, The requirements are as follows: the output must be short and consist of a sentence, each subsql generates half a sentence, split by ',', only the reasoning process needs to be output and output in English:
**generate reasoning process:**:First, select information from satscores, then join the schools table, add school information, and add a filter based on Ricci Ulrich; finally, choose to display the average writing score.

question: {question}
evidence: {evidence}
subsql list: 
{subsql_content}
Now, The requirements are as follows: the output must be short and consist of a sentence,each subsql generates half a sentence, split by ',', only the reasoning process needs to be output and output in English:
**generate reasoning process:**:"""
    return content




# zero shot and CoT
def generate_CoT_zero_shot_path(sql,question, evidence):
    content = f"""Generate a clear, concise chain of thought (CoT) reasoning process that explains how the SQL query incrementally builds towards answering the original question. The reasoning should break down the steps logically, starting from identifying the necessary tables and conditions, and moving through the process of how the SQL query is constructed to answer the question. Each step should follow from the previous one, and the reasoning should be simple and direct.

The output must be a sentence, split by commas, only explaining the reasoning process, and output in English. 

question: {question}
evidence: {evidence}
SQL: {sql}
Now, the output must meet the following criteria:
- Provide a step-by-step reasoning process that links each step of the SQL query to the question.
- The output must be short, clear, and concise, with each step explained in a sentence, separated by commas.

**generate reasoning process**:"""
    return content

