
function pm_next!(pm, stat::NamedTuple)
    ProgressMeter.next!(pm; showvalues=[tuple(s...) for s in pairs(stat)])
end

function construct_scale(::Val{:squareroot}, ::Any, C, ::Any)
    C
end

function construct_scale(::Val{:cholesky}, s, L_low, ϕ)
    LowerTriangular(L_low + Diagonal(ϕ.(s)))
end

function construct_scale(::Val{:meanfield}, s, ::Any, ϕ)
    Diagonal(ϕ.(s))
end

function contruct_q(param_type, λ, ϕ, unflatten)
    m, s, L_low = unflatten(λ)
    L           = construct_scale(Val(param_type), s, L_low, ϕ)
    Σ_chol      = if L isa LowerTriangular
        PDMat(L*L', Cholesky(L))
    elseif L isa Diagonal
        PDiagMat(diag(L).^2)
    else
        PDMat(L*L' |> Hermitian)
    end
    MvNormal(m, Σ_chol)
end
