
struct ZygoteAD end

function grad!(
    f::Function,
    ::Type{<:ZygoteAD},
    λ::AbstractVector{<:Real},
    out::DiffResults.MutableDiffResult,
    )
    y, back = Zygote.pullback(f, λ)
    dy = first(back(1.0))
    DiffResults.value!(out, y)
    DiffResults.gradient!(out, dy)
    return out
end

struct ReverseDiffAD end

tape(f, x) = ReverseDiff.GradientTape(f, x)
function taperesult(f, x)
    return tape(f, x), ReverseDiff.GradientResult(x)
end

function grad!(
    f::Function,
    ::Type{<:ReverseDiffAD},
    λ::AbstractVector{<:Real},
    out::DiffResults.MutableDiffResult,
    )
    tp = tape(f, λ)
    ReverseDiff.gradient!(out, tp, λ)
    return out
end

struct ForwardDiffAD end

function grad!(
    f::Function,
    ::Type{<:ForwardDiffAD},
    λ::AbstractVector{<:Real},
    out::DiffResults.MutableDiffResult
)
    # Set chunk size and do ForwardMode.
    config = ForwardDiff.GradientConfig(f, λ)
    ForwardDiff.gradient!(out, f, λ, config)
end

struct EnzymeAD end

function grad!(
    f::Function,
    ::Type{<:EnzymeAD},
    λ::AbstractVector{<:Real},
    out::DiffResults.MutableDiffResult
)
    y = f(λ)
    DiffResults.value!(out, y)
    dy = DiffResults.gradient(out)
    fill!(dy, 0)
    Enzyme.autodiff(Enzyme.Reverse, f, Enzyme.Active, Enzyme.Duplicated(λ, dy))
end

