def get_dataset_specified_config(dataset, trainer, task):
    """Get dataset specific."""
    assert task in ["B2N", "CD"], "The TASK must be either B2N, CD, or FS."
    assert trainer in ["PGMPL", "MMRL"], "The TRAINER must be either MMRL or MMRLpp."
    if trainer in ["PGMPL"]:
        cfg = {
            "StanfordCars": {
                "TRAINER.MMRL.REG_WEIGHT": 7.0,
                "TRAINER.MMRL.NUM_CLASSES_TRAIN": 98,   # if task=CD =1000
                "DATALOADER.TRAIN_X.BATCH_SIZE": 4,
                "TRAINER.MMRL.ALPHA2": 0.5,
                "TRAINER.MMRL.BETA0": 0.6,
                "TRAINER.MMRL.BETA1": 0.5,
                "TRAINER.MMRL.BETA2": 0.5,
                "TRAINER.MMRL.TOP_K": 30,
            },
            "FGVCAircraft": {
                "TRAINER.MMRL.REG_WEIGHT": 6.0,
                "TRAINER.MMRL.NUM_CLASSES_TRAIN": 50,
                "DATALOADER.TRAIN_X.BATCH_SIZE": 4,
                "TRAINER.MMRL.ALPHA2": 0.5,
                "TRAINER.MMRL.BETA0": 0.5,
                "TRAINER.MMRL.BETA1": 0.6,
                "TRAINER.MMRL.BETA2": 0.5,
                "TRAINER.MMRL.TOP_K": 20,
            },
            "SUN397": {
                "TRAINER.MMRL.REG_WEIGHT": 6.0,
                "TRAINER.MMRL.NUM_CLASSES_TRAIN": 199,
                "DATALOADER.TRAIN_X.BATCH_SIZE": 4,
                "TRAINER.MMRL.ALPHA2": 0.5,
                "TRAINER.MMRL.BETA0": 0.5,
                "TRAINER.MMRL.BETA1": 0.4,
                "TRAINER.MMRL.BETA2": 0.5,
                "TRAINER.MMRL.TOP_K": 70,
            },
            "DescribableTextures": {
                "TRAINER.MMRL.REG_WEIGHT": 6.0,
                "TRAINER.MMRL.NUM_CLASSES_TRAIN": 24,
                "DATALOADER.TRAIN_X.BATCH_SIZE": 8,
                "TRAINER.MMRL.ALPHA2": 0.5,
                "TRAINER.MMRL.BETA0": 0.5,
                "TRAINER.MMRL.BETA1": 0.5,
                "TRAINER.MMRL.BETA2": 0.5,
                "TRAINER.MMRL.TOP_K": 20,
            },
            "Food101": {
                "TRAINER.MMRL.REG_WEIGHT": 5.0,
                "TRAINER.MMRL.NUM_CLASSES_TRAIN": 51,
                "DATALOADER.TRAIN_X.BATCH_SIZE": 16,
                "TRAINER.MMRL.ALPHA2": 0.5,
                "TRAINER.MMRL.BETA0": 0.6,
                "TRAINER.MMRL.BETA1": 0.6,
                "TRAINER.MMRL.BETA2": 0.5,
                "TRAINER.MMRL.TOP_K": 200,
            },
            "OxfordFlowers": {
                "TRAINER.MMRL.REG_WEIGHT": 4.0,
                "TRAINER.MMRL.NUM_CLASSES_TRAIN": 51,
                "DATALOADER.TRAIN_X.BATCH_SIZE": 8,
                "TRAINER.MMRL.ALPHA2": 0.5,
                "TRAINER.MMRL.BETA0": 0.5,
                "TRAINER.MMRL.BETA1": 0.4,
                "TRAINER.MMRL.BETA2": 0.5,
                "TRAINER.MMRL.TOP_K": 15,
            },
            "UCF101": {
                "TRAINER.MMRL.REG_WEIGHT": 3.0,
                "TRAINER.MMRL.NUM_CLASSES_TRAIN": 51,
                "DATALOADER.TRAIN_X.BATCH_SIZE": 16,
                "TRAINER.MMRL.ALPHA2": 0.5,
                "TRAINER.MMRL.BETA0": 0.6,
                "TRAINER.MMRL.BETA1": 0.4,
                "TRAINER.MMRL.BETA2": 0.5,
                "TRAINER.MMRL.TOP_K": 25,
            },
            "ImageNet": {
                "TRAINER.MMRL.REG_WEIGHT": 0.5,
                "TRAINER.MMRL.NUM_CLASSES_TRAIN": 500,
                "DATALOADER.TRAIN_X.BATCH_SIZE": 4,
                "TRAINER.MMRL.ALPHA2": 0.7,
                "TRAINER.MMRL.BETA0": 0.6,
                "TRAINER.MMRL.BETA1": 0.5,
                "TRAINER.MMRL.BETA2": 0.5,
                "TRAINER.MMRL.TOP_K": 40,
            },
            "Caltech101": {
                "TRAINER.MMRL.REG_WEIGHT": 0.5,
                "TRAINER.MMRL.NUM_CLASSES_TRAIN": 50,
                "DATALOADER.TRAIN_X.BATCH_SIZE": 4,
                "TRAINER.MMRL.ALPHA2": 0.5,
                "TRAINER.MMRL.BETA0": 0.4,
                "TRAINER.MMRL.BETA1": 0.6,
                "TRAINER.MMRL.BETA2": 0.5,
                "TRAINER.MMRL.TOP_K": 15,
            },
            "OxfordPets": {
                "TRAINER.MMRL.REG_WEIGHT": 0.2,
                "TRAINER.MMRL.NUM_CLASSES_TRAIN": 19,
                "DATALOADER.TRAIN_X.BATCH_SIZE": 32,
                "TRAINER.MMRL.ALPHA2": 0.5,
                "TRAINER.MMRL.BETA0": 0.5,
                "TRAINER.MMRL.BETA1": 0.6,
                "TRAINER.MMRL.BETA2": 0.5,
                "TRAINER.MMRL.TOP_K": 80,
            },
            "EuroSAT": {
                "TRAINER.MMRL.REP_DIM": 2048,
                "TRAINER.MMRL.REG_WEIGHT": 0.4,
                "TRAINER.MMRL.NUM_CLASSES_TRAIN": 5,
                "DATALOADER.TRAIN_X.BATCH_SIZE": 8,
                "TRAINER.MMRL.ALPHA2": 0.5,
                "TRAINER.MMRL.BETA0": 0.4,
                "TRAINER.MMRL.BETA1": 0.5,
                "TRAINER.MMRL.BETA2": 0.5,
                "TRAINER.MMRL.TOP_K": 600,
            },
            "ImageNetV2":{
                "TRAINER.MMRL.ALPHA2": 0.7,
                "TRAINER.MMRL.BETA0": 0.6,
                "TRAINER.MMRL.BETA1": 0.5,
                "TRAINER.MMRL.BETA2": 0.5,
            },
            "ImageNetR":{
                "TRAINER.MMRL.ALPHA2": 0.7,
                "TRAINER.MMRL.BETA0": 0.6,
                "TRAINER.MMRL.BETA1": 0.5,
                "TRAINER.MMRL.BETA2": 0.5,
            },
            "ImageNetA":{
                "TRAINER.MMRL.ALPHA2": 0.7,
                "TRAINER.MMRL.BETA0": 0.6,
                "TRAINER.MMRL.BETA1": 0.5,
                "TRAINER.MMRL.BETA2": 0.5,
            },
            "ImageNetSketch":{
                "TRAINER.MMRL.ALPHA2": 0.7,
                "TRAINER.MMRL.BETA0": 0.6,
                "TRAINER.MMRL.BETA1": 0.5,
                "TRAINER.MMRL.BETA2": 0.5,
            },
        }.get(dataset, {})
        if task in ["CD"]:
            cfg["TRAINER.MMRL.NUM_CLASSES_TRAIN"] = 1000
            
    elif trainer in ["MMRL"]:
        cfg = {
            "StanfordCars": {
                "TRAINER.MMRL.REG_WEIGHT": 7.0,
            },
            "FGVCAircraft": {
                "TRAINER.MMRL.REG_WEIGHT": 6.0,
            },
            "SUN397": {
                "TRAINER.MMRL.REG_WEIGHT": 6.0,
            },
            "DescribableTextures": {
                "TRAINER.MMRL.REG_WEIGHT": 6.0,
            },
            "Food101": {
                "TRAINER.MMRL.REG_WEIGHT": 5.0,
            },
            "OxfordFlowers": {
                "TRAINER.MMRL.REG_WEIGHT": 4.0,
            },
            "UCF101": {
                "TRAINER.MMRL.REG_WEIGHT": 3.0,
            },
            "ImageNet": {
                "TRAINER.MMRL.REG_WEIGHT": 0.5,
            },
            "Caltech101": {
                "TRAINER.MMRL.REG_WEIGHT": 0.5,
            },
            "OxfordPets": {
                "TRAINER.MMRL.REG_WEIGHT": 0.2,
            },
            "EuroSAT": {
                "TRAINER.MMRL.REP_DIM": 2048,
                "TRAINER.MMRL.REG_WEIGHT": 0.01,
            },
        }.get(dataset, {})

    return [item for pair in cfg.items() for item in pair]