export WANDB_DISABLED="true"
export CUDA_VISIBLE_DEVICES=1

DATA="cifar10"

for SEED in 2
do
    TRAIN_DIR="~/unlearning/cure_newton/sequential_unlearning/${DATA}-class/seed-$SEED"
    UNLEARN_DIR="${TRAIN_DIR}/by-class"

    # train model
    # python settings/train.py \
    #     --dataset $DATA \
    #     --seed $SEED \
    #     --save_dir $TRAIN_DIR 

    # select forgotten points
    # python settings/select_points.py \
    #     --dataset $DATA \
    #     --seed $SEED \
    #     --sel_level class \
    #     --sel_freq -2 \
    #     --sel_sort_by random \
    #     --model_dir $TRAIN_DIR \
    #     --save_dir $UNLEARN_DIR 

    # unlearn
    for UNLEARN_METHOD in scr_newton
    do
        python main/sequential_unlearning.py \
            --dataset $DATA \
            --seed $SEED \
            --train_config_path configs/train/cifar10.json \
            --unlearn_config_path configs/unlearn/cifar10_class.json \
            --model_path ${TRAIN_DIR}/original.pt \
            --unlearn_method ${UNLEARN_METHOD} \
            --save_dir ${UNLEARN_DIR} \
            --exp_name ${UNLEARN_METHOD} \
            --unlearn_batch_size 1000 
    done
done