export WANDB_DISABLED="true"
export CUDA_VISIBLE_DEVICES=3

DATA="fashion_mnist"

for SEED in 5
do
    TRAIN_DIR="~/unlearning/cure_newton/batch_unlearning/${DATA}/seed-$SEED"
    UNLEARN_DIR="${TRAIN_DIR}/by-instance"

    # train model
    # python settings/train.py \
    #     --dataset $DATA \
    #     --seed $SEED \
    #     --save_dir $TRAIN_DIR 

    # select forgotten points
    # python settings/select_points.py \
    #     --dataset $DATA \
    #     --seed $SEED \
    #     --sel_level class \
    #     --sel_freq -1 \
    #     --sel_sort_by random \
    #     --model_dir $TRAIN_DIR \
    #     --save_dir $UNLEARN_DIR 

    # unlearn
    for UNLEARN_METHOD in ga 
        do
        python main/sequential_unlearning.py \
            --dataset ${DATA} \
            --train_config_path configs/train/fashion_mnist.json \
            --unlearn_config_path configs/unlearn/fashion_mnist_instance.json \
            --seed $SEED \
            --model_path $TRAIN_DIR/original.pt \
            --save_dir ${UNLEARN_DIR} \
            --exp_name ${UNLEARN_METHOD} \
            --unlearn_method ${UNLEARN_METHOD} \
            --unlearn_batch_size -1 
        done
done