# Sequential Controlled Langevin Diffusions 

This repository builds on the public codebase (https://github.com/DenisBless/variational_sampling_methods) of "[Beyond ELBOs: A Large-Scale Evaluation of Variational Methods for Sampling](https://arxiv.org/abs/2406.07423). We implement the SCLD Algorithm [here](algorithms/scld/). You can run using

```
python3 run.py algorithm=scld target=seeds
```
You can set configuration parameters in the scld config file and the config file of the target.


## Other Available Algorithms from Original Repo
The table below provides a overview of all available algorithms.

| **Acronym**               | **Method** | **Reference** |
|---------------------------|------------|---------------|
| [MFVI](algorithms/mfvi)   | Gaussian Mean-Field VI | [Bishop, 2006](https://www.microsoft.com/en-us/research/uploads/prod/2006/01/Bishop-Pattern-Recognition-and-Machine-Learning-2006.pdf) |
| [GMMVI](algorithms/gmmvi) | Gaussian Mixture Model VI | [Arenz et al., 2022](https://arxiv.org/abs/2209.11533) |
| [NFVI](algorithms/nfvi)   | Normalizing Flow VI | [Rezende & Mohamed, 2015](https://arxiv.org/abs/1505.05770) |
| [SMC](algorithms/smc)     | Sequential Monte Carlo | [Del Moral et al., 2006](https://www.stats.ox.ac.uk/~doucet/delmoral_doucet_jasra_sequentialmontecarlosamplersJRSSB.pdf) |
| [AFT](algorithms/aft)     | Annealed Flow Transport | [Arbel et al., 2021](https://arxiv.org/abs/2102.07501) |
| [CRAFT](algorithms/craft) | Continual Repeated AFT | [Matthews et al., 2022](https://arxiv.org/abs/2201.13117) |
| [FAB](algorithms/fab)     | Flow Annealed IS Bootstrap | [Midgley et al., 2022](https://arxiv.org/abs/2208.01893) |
| [ULA](algorithms/ula)     | Uncorrected Langevin Annealing | [Thin et al., 2021](https://arxiv.org/abs/2106.15921) |
| [MCD](algorithms/mcd)     | Monte Carlo Diffusion | [Doucet et al., 2022](https://arxiv.org/abs/2208.07698) |
| [UHA](algorithms/uha)     | Uncorrected Hamiltonian Annealing | [Geffner et al., 2021](https://arxiv.org/abs/2107.04150) |
| [LDVI](algorithms/ldvi)   | Langevin Diffusion VI | [Geffner et al., 2022](https://arxiv.org/abs/2208.07743) |
| [CMCD](algorithms/cmcd)   | Controlled MCD | [Vargas et al., 2023](https://arxiv.org/abs/2307.01050) |
| [PIS](algorithms/pis)     | Path Integral Sampler | [Zhang et al., 2021](https://arxiv.org/abs/2111.15141) |
| [DIS](algorithms/dis)     | Time-Reversed Diffusion Sampler | [Berner et al., 2022](https://openreview.net/pdf?id=oYIjw37pTP) |
| [DDS](algorithms/dds)     | Denoising Diffusion Sampler | [Vargas et al., 2023](https://arxiv.org/abs/2302.13834) |
| [GFN](algorithms/gfn)     | Generative Flow Networks | [Lahlou et al., 2023](https://arxiv.org/abs/2301.12594) |
| [GBS](algorithms/gbs)     | General Bridge Sampler | [Richter et al., 2023](https://arxiv.org/abs/2307.01198) |
The respective configuration files can be found [here](configs/algorithm).

## Available Target Densities

The respective configuration files can be found [here](configs/target).

## Installation

We recommend using [Conda](https://conda.io/docs/user-guide/install/download.html) to set up the codebase:
  ```
  conda create -n sampling_bench python==3.10.14 pip --yes
  conda activate sampling_bench
  ```
Install the required packages using 
  ```
  pip install -r requirements.txt
  ```
Finally, we use [`wandb`](https://wandb.ai/) for experiment tracking. Login to your wandb account:
  ```
  wandb login
  ```
  You can also omit this step and add the `use_wandb=False` command line arg to your runs.


## Running Experiments

### Configuration
We use [`hydra`](https://hydra.cc/) for config management. The [base configuration](configs/base_conf.yaml) file sets 
parameters that are agnostic to the specific choice of algorithm and target density. The `wandb` entity can be set in the [setup config file](configs/setup.yaml).


## Acknowledgements
Portions of the project are adapted from other repositories (as mentioned in the code): 
- https://github.com/shreyaspadhy/CMCD is licensed under MIT,
- https://github.com/OlegArenz/gmmvi is licensed under MIT,
- https://github.com/lollcat/fab-jax is licensed under MIT,
- https://github.com/tomsons22/LDVI is licensed under MIT,
- https://github.com/juliusberner/sde_sampler is licensed under MIT,
- https://github.com/franciscovargas/denoising_diffusion_samplers is licensed under MIT,
- https://github.com/antoninschrab/mmdfuse is licensed under MIT,
- https://github.com/google-deepmind/annealed_flow_transport is licensed under Apache-2.0. 
