"""
Author:
--------
Abhinandan Pal  
University of Birmingham

Copyright:
-----------
© 2024 University of Birmingham. All rights reserved.
"""

import os
import time

"""
runNuXmv Function Documentation

Overview:
----------
The runABC function automates the process of formal verification for a SystemVerilog hardware design using the nuXmv model checker. 
It follows these steps:

1. Converts the SystemVerilog (.sv) file into an SMV format using EBMC.
2. Modifies the generated SMV file by appending LTL specifications.
3. Executes the nuXmv model checker on the modified SMV file.
4. Display and Log the time taken for the entire process.

Parameters:
------------
- name (str): 
    The name of the hardware design (without the file extension). 
    Used for uniqely identifying different .sv, .smv, and .aig files across all experiments.
    
- module_name (str): 
    The top-level module name within the SystemVerilog design.
    
- nuXmvSpec (str): 
    LTL specifications (in SMV format) to be appended to the generated SMV file.
    
- idtext (str): 
    An identifier string, used to label the timing entry in the log file.

"""

def runNuXmv(name, module_name, nuXmvSpec, idtext):
	begin = time.time()
	os.system(f"rm ../../Tools/nuXmv/SMV/{name}.smv")
	os.system(f"../../Tools/ebmc/ebmc_v5_x ../../Benchmarks/{name}.sv --smv-netlist --bound 0 --top {module_name} > ../../Tools/nuXmv/SMV/{name}.smv")
	data = ""
	with open(f"../../Tools/nuXmv/SMV/{name}.smv", 'r') as file:
	    data = file.read()
	data = data[data.find('-- Generated by EBMC') : data.find('-- Initial state')]
	data += "\n\n"+ nuXmvSpec
	with open(f"../../Tools/nuXmv/SMV/{name}.smv", "w") as file:
	    file.write(data)
	os.system(f"../../Tools/nuXmv/nuXmv ../../Tools/nuXmv/SMV/{name}.smv")
	end = time.time()
	print(f"\n\nnuXmv TIME: {end - begin}\n")

