# Supplemental Material for "Semi-supervised learning of partial differential operators and dynamical flows"
Parts of this code are taken from [https://github.com/zongyi-li/fourier_neural_operator](https://github.com/zongyi-li/fourier_neural_operator)
## Requirements

- [PyTorch 1.8.1](https://pytorch.org/)

## Files

The code is in the form of simple scripts. Each script shall be stand-alone and directly runnable.

- `hyper_1d.py` is the Fourier Neural Operator for 1D problem such as the 1D Burgers & Chafee-Infante equations.
- `hyper_2d.py` is the Fourier Neural Operator for 2D problem such as the 2D Burgers & Navier-Stokese quations.
- `hyper_3d.py` is the Fourier Neural Operator for 3D problem such as the 3D Navier-Stokes equation.

## Execution

For all experiments, to run FNO, simply add the --vanilla flag as an argument. For the MGNO we used the official repository available at: [https://github.com/zongyi-li/graph-pde](https://github.com/zongyi-li/graph-pde)
### 1D Experiments:

The -i flag includes the $\mathcal{L}_{inter}$ term. --order flag is $P-1$. For the regular Burgers:

```bash 
python hyper_1d.py -r -i --order 1 -d old --uniformintervals --use_tanh --epochs 500
```

For the Chafee-Infante

```bash 
python hyper_1d.py -r -i --order 1 -d chafee --uniformintervals --use_tanh --epochs 500
```

For the Generalized Burgers, where the -g flag is the order $q$ of the generalized burgers.

```bash
python hyper_1d.py -r -i --order 1 -d --epochs 500 -g 2 --uniformintervals --use_tanh --epochs 500
```

### 2D Experiments

For the 2D burgers:

```bash
python hyper_2d.py -d burgers2d --order 1  --use_tanh --epochs 500 -i --uniformintervals
```

For the 2D Navier Stokes:

```bash
python hyper_2d.py -d navier --order 1  --use_tanh --epochs 500 -i --uniformintervals
```

### 3D Experiments

```bash
python hyper_3d.py -d navier --order 0  --use_tanh --epochs 500 -i --uniformintervals
```

## Datasets



## Dataset Generation

### 1D PDEs
The Burgers 1D dataset may be obtained
from [Burgers 1D](https://drive.google.com/drive/folders/1UnbQh2WWc6knEHbLn-ZaXrKUZhp7pjt-?usp=sharing), Burgers_R10.zip.


The other 1D datasets are generated as follows:
```bash
    python generate_gt_pypde.py -ntr 1000 -nts 100 -pde gburgers2 -d burgers_data_R10.mat # Generalized Burgers q=2
    python generate_gt_pypde.py -ntr 1000 -nts 100 -pde gburgers3 -d burgers_data_R10.mat # Generalized Burgers q=3
    python generate_gt_pypde.py -ntr 1000 -nts 100 -pde gburgers4 -d burgers_data_R10.mat # Generalized Burgers q=4
    python generate_gt_pypde.py -ntr 1000 -nts 100 -pde chafee -d burgers_data_R10.mat # Chafee-Infante
```

### 2D Burgers

```bash
    python generate_2d_burgers_data.py
```

### 2D Navier Stokes

```bash
    python generate_2d_navier_data.py
```

### 3D Navier Stokes

```
    python generate_3d_navier_data.py
```
