# AbdCTBench Dataset - Supplementary Materials

## Dataset Overview

AbdCTBench is a comprehensive dataset derived from 23,506 abdominal computed tomography (CT) scans of 18,719 patients representing one of the largest CT-derived biomarker datasets for abdominal body composition analysis. While we plan to release the dataset, evaluation protocols, and baseline models to accelerate research in representation learning for medical applications, immediately following the review period, we provide the test set and sample test images as supplementary materials to assist in the submission review.

## Data Collection and IRB Approval

### Institutional Review Board (IRB) Approval
This dataset was collected under Institutional Review Board (IRB) approval obtained from the **University of Wisconsin IRB** under Protocol Title: **"Opportunistic CT Screening"**.

### Data Source
- **Collection Period**: August 11, 2003, to September 9, 2021
- **Patient Population**: 18,719 unique patients with diverse demographics and clinical conditions

### Data Processing and Privacy
- **HIPAA Compliance**: The dataset has been processed to comply with HIPAA Safe Harbor de-sensitization requirements
- **Privacy Protection**: All personally identifiable information (PII) has been removed for safe public release
- **Data Split**: 70/20/10 train/validation/test split at the patient ID level to prevent data leakage

### File Structure
```
SupplementaryMaterials/
├── README.md                    # This file
├── test.csv                     # Test set metadata and labels
└── test_images_sample/          # Sample test images
    └── [PNG files]              # 2D surface mesh images
```

## Usage Guidelines

### Research Use
This dataset is intended for research purposes in:
- Medical imaging and computer vision
- Body composition analysis
- Biomarker prediction from surface geometry
- Clinical outcome prediction

### Citation
If you use this dataset in your research, please cite the associated paper:
```
[Citation information will be provided upon publication]
```

## Ethical Considerations

- All data collection and processing was conducted in compliance with institutional and federal regulations
- Patient privacy and confidentiality were maintained throughout the research process

---

*Last updated: September 2025*
