## EDSNN: Edge Detection with Spiking Neuron Network

![Optional image alt text](figure.png)



The repository contains the authoritative codebase for "EDSNN: Edge Detection with Spiking Neuron Network".

## Training

### Training for EDSNN

CUDA_VISIBLE_DEVICES=0,1 python main.py --seed 42 --train_batch_size 8 --test_batch_size 1\
    --num_workers 12 --epochs 21 --sampler_num 40000\
    --lr 1e-4 --lr_stepsize 5 --lr_gamma 0.1\
    --weight_decay 0.0005 --print_freq 1000 --store_folder "./EDSNN_edge"\
    --seed 42 --dataset "./edge_data/BSDS500_flipped_rotated_pad/" --optimizer_method "Adam" --loss_method "Hybrid"\
    --T 4 --step_mode "m" --amp

## Evaluation

When conducting evaluation, one must replace the applicable pretrained model information in the suitable main folder.

### Evaluation for EDSNN

CUDA_VISIBLE_DEVICES=0,1 python main.py --seed 42 --train_batch_size 8 --test_batch_size 1\
    --num_workers 12 --epochs 21 --sampler_num 40000\
    --lr 1e-4 --lr_stepsize 5 --lr_gamma 0.1\
    --weight_decay 0.0005 --print_freq 1000 --store_folder "./EDSNN_edge"\
    --seed 42 --dataset "./edge_data/BSDS500_flipped_rotated_pad/" --optimizer_method "Adam" --loss_method "Hybrid"\
    --T 4 --step_mode "m" --amp --resume "./EDSNN_edge/epoch-15-ckpt.pt" --test

### Code Acknowledgments

This code is based on [Holistically-nested edge detection](https://github.com/xwjabc/hed) . Thanks to the contributors of [Holistically-nested edge detection](https://github.com/xwjabc/hed) .

```
@inproceedings{xie2015holistically,
  title={Holistically-nested edge detection},
  author={Xie, Saining and Tu, Zhuowen},
  booktitle={Proceedings of the IEEE international conference on computer vision},
  pages={1395--1403},
  year={2015}
}
```

