
set -x
set -e

export RETRIEVAL_TYPE="ance"  # bge, ance, bm25
export IP_ADDRESS="0.0.0.0"
export IP_PORT="8000"
export USE_HNSW="0"



# Argument parsing
CONFIG_PATH="evaluation/config.yaml"
MODEL_NAME=""
MODEL_SMN=""
OUTPUT_DIR=""

# Parse command-line arguments
while [[ $# -gt 0 ]]; do
    case $1 in
        --config)
            CONFIG_PATH="$2"
            shift 2
            ;;
        --model-name)
            MODEL_NAME="$2"
            shift 2
            ;;
        --model-smn)
            MODEL_SMN="$2"
            shift 2
            ;;
        --output-dir)
            OUTPUT_DIR="$2"
            shift 2
            ;;
        *)
            echo "Unknown parameter: $1"
            echo "Usage: $0 [--config CONFIG_PATH] [--model-name MODEL_NAME] [--model-smn MODEL_SMN] [--output-dir OUTPUT_DIR]"
            exit 1
            ;;
    esac
done

script_dir=$(dirname "$(realpath "${BASH_SOURCE[0]}")")

# Build Python script arguments
PYTHON_ARGS="--config $CONFIG_PATH"
if [ -n "$MODEL_NAME" ]; then
    PYTHON_ARGS="$PYTHON_ARGS --model-name $MODEL_NAME"
fi
if [ -n "$MODEL_SMN" ]; then
    PYTHON_ARGS="$PYTHON_ARGS --model-smn $MODEL_SMN"
fi

# Special parameters for eval.py
EVAL_ARGS="$PYTHON_ARGS"
if [ -n "$OUTPUT_DIR" ]; then
    EVAL_ARGS="$EVAL_ARGS --output-dir $OUTPUT_DIR"
fi

# Run Python scripts
python ${script_dir}/1_vllm_inference.py $PYTHON_ARGS
python ${script_dir}/2_computer_score.py $PYTHON_ARGS
python ${script_dir}/eval.py $EVAL_ARGS
# python ${script_dir}/3_filter.py $PYTHON_ARGS