set -x
# set -e
nohup python search_launch/lucene/search_server_multi_cpu.py \
    --index-dir local_index_search/hotpotqa/lucene \
    --port 8003 \
    --num-cpus 256 \
    --k1 1.2 \
    --b 0.75 > logs/service.log 2>&1 &

sleep 60
# Set retriever type
export RETRIEVAL_TYPE="bm25"  # Options: bge, ance
# Set server configuration

export IP_ADDRESS="0.0.0.0"
export IP_PORT="8003"

NAME="hp_bm25"
python3 -m recipe.dapo.main_dapo \
    trainer.default_local_dir=checkpoints/${NAME} \
    data.filter_overlong_prompts=True \
    data.train_files=./data/hotpotqa_new/bm25/train.parquet \
    data.val_files=./data/hotpotqa_new/test.parquet \
    data.train_batch_size=256 \
    data.gen_batch_size=512 \
    data.max_prompt_length=512 \
    data.max_response_length=256 \
    actor_rollout_ref.model.path=LLM/Qwen/Qwen2.5-3B \
    actor_rollout_ref.actor.optim.lr=1e-6 \
    actor_rollout_ref.actor.ppo_mini_batch_size=64 \
    actor_rollout_ref.actor.ppo_micro_batch_size_per_gpu=8 \
    actor_rollout_ref.rollout.log_prob_micro_batch_size_per_gpu=8 \
    actor_rollout_ref.rollout.tensor_model_parallel_size=1 \
    actor_rollout_ref.rollout.gpu_memory_utilization=0.9 \
    actor_rollout_ref.ref.log_prob_micro_batch_size_per_gpu=8 \
    actor_rollout_ref.rollout.max_num_batched_tokens=11408 \
    actor_rollout_ref.rollout.temperature=0.8 \
    actor_rollout_ref.rollout.top_p=0.8 \
    actor_rollout_ref.rollout.top_k=-1 \
    actor_rollout_ref.rollout.val_kwargs.temperature=0.7 \
    actor_rollout_ref.rollout.val_kwargs.top_p=0.8 \
    actor_rollout_ref.rollout.val_kwargs.top_k=20 \
    actor_rollout_ref.rollout.val_kwargs.do_sample=True \
    actor_rollout_ref.rollout.val_kwargs.n=8 \
    actor_rollout_ref.rollout.n=8 \
    algorithm.adv_estimator=grpo \
    algorithm.use_kl_in_reward=False \
    algorithm.kl_ctrl.kl_coef=0.001 \
    actor_rollout_ref.actor.use_kl_loss=False \
    actor_rollout_ref.actor.kl_loss_coef=0.0 \
    actor_rollout_ref.actor.clip_ratio_low=0.2 \
    actor_rollout_ref.actor.clip_ratio_high=0.28 \
    actor_rollout_ref.actor.clip_ratio_c=10.0 \
    actor_rollout_ref.actor.loss_agg_mode=token-mean \
    algorithm.filter_groups.enable=True \
    algorithm.filter_groups.metric=score \
    algorithm.filter_groups.max_num_gen_batches=20 \
    reward_model.reward_manager=dapo \
    reward_model.overlong_buffer.enable=True \
    reward_model.overlong_buffer.len=256 \
    reward_model.overlong_buffer.penalty_factor=1.0 \
    reward_model.overlong_buffer.log=False \
    actor_rollout_ref.model.use_remove_padding=True \
    actor_rollout_ref.actor.use_dynamic_bsz=True \
    actor_rollout_ref.ref.log_prob_use_dynamic_bsz=True \
    actor_rollout_ref.rollout.log_prob_use_dynamic_bsz=True \
    actor_rollout_ref.actor.entropy_coeff=0 \
    actor_rollout_ref.actor.grad_clip=1.0 \
    trainer.logger='[console, swanlab]' \
    trainer.project_name=hotpotqa \
    trainer.experiment_name=${NAME} \
    trainer.val_before_train=False \
    trainer.default_hdfs_dir=null \
    trainer.n_gpus_per_node=8 \
    trainer.nnodes=1 \
    trainer.save_freq=24 \
    trainer.test_freq=18 \
    trainer.total_epochs=3 \
    custom_reward_function.path=verl/utils/reward_score/stage1.py \
    custom_reward_function.name=compute_score \
    2>&1 | tee logs/hotpotqa/${NAME}.log

export PYTHONPATH=.
python scripts/model_merger.py merge \
    --backend fsdp \
    --local_dir checkpoints/hp_bm25/global_step_144/actor \
    --target_dir sft_checkpoints/HP/hp_bm25_step144

NAME="hp_bm25_step144_stage3_hard"
python3 -m recipe.dapo.main_dapo \
    trainer.default_local_dir=checkpoints/${NAME} \
    data.filter_overlong_prompts=True \
    data.train_files=./data/hotpotqa_new/bm25/train_hard.parquet \
    data.val_files=./data/hotpotqa_new/test.parquet \
    data.train_batch_size=256 \
    data.gen_batch_size=512 \
    data.max_prompt_length=512 \
    data.max_response_length=256 \
    actor_rollout_ref.model.path=sft_checkpoints/HP/hp_bm25_step144 \
    actor_rollout_ref.actor.optim.lr=1e-6 \
    actor_rollout_ref.actor.ppo_mini_batch_size=64 \
    actor_rollout_ref.actor.ppo_micro_batch_size_per_gpu=8 \
    actor_rollout_ref.rollout.log_prob_micro_batch_size_per_gpu=8 \
    actor_rollout_ref.rollout.tensor_model_parallel_size=1 \
    actor_rollout_ref.rollout.gpu_memory_utilization=0.9 \
    actor_rollout_ref.ref.log_prob_micro_batch_size_per_gpu=8 \
    actor_rollout_ref.rollout.max_num_batched_tokens=11408 \
    actor_rollout_ref.rollout.temperature=0.8 \
    actor_rollout_ref.rollout.top_p=0.8 \
    actor_rollout_ref.rollout.top_k=-1 \
    actor_rollout_ref.rollout.val_kwargs.temperature=0.7 \
    actor_rollout_ref.rollout.val_kwargs.top_p=0.8 \
    actor_rollout_ref.rollout.val_kwargs.top_k=20 \
    actor_rollout_ref.rollout.val_kwargs.do_sample=True \
    actor_rollout_ref.rollout.val_kwargs.n=8 \
    actor_rollout_ref.rollout.n=8 \
    algorithm.adv_estimator=grpo \
    algorithm.use_kl_in_reward=False \
    algorithm.kl_ctrl.kl_coef=0.001 \
    actor_rollout_ref.actor.use_kl_loss=False \
    actor_rollout_ref.actor.kl_loss_coef=0.0 \
    actor_rollout_ref.actor.clip_ratio_low=0.2 \
    actor_rollout_ref.actor.clip_ratio_high=0.28 \
    actor_rollout_ref.actor.clip_ratio_c=10.0 \
    actor_rollout_ref.actor.loss_agg_mode=token-mean \
    algorithm.filter_groups.enable=True \
    algorithm.filter_groups.metric=score \
    algorithm.filter_groups.max_num_gen_batches=20 \
    reward_model.reward_manager=dapo \
    reward_model.overlong_buffer.enable=True \
    reward_model.overlong_buffer.len=256 \
    reward_model.overlong_buffer.penalty_factor=1.0 \
    reward_model.overlong_buffer.log=False \
    actor_rollout_ref.model.use_remove_padding=True \
    actor_rollout_ref.actor.use_dynamic_bsz=True \
    actor_rollout_ref.ref.log_prob_use_dynamic_bsz=True \
    actor_rollout_ref.rollout.log_prob_use_dynamic_bsz=True \
    actor_rollout_ref.actor.entropy_coeff=0 \
    actor_rollout_ref.actor.grad_clip=1.0 \
    trainer.logger='[console, swanlab]' \
    trainer.project_name=hotpotqa \
    trainer.experiment_name=${NAME} \
    trainer.val_before_train=False \
    trainer.default_hdfs_dir=null \
    trainer.n_gpus_per_node=8 \
    trainer.nnodes=1 \
    trainer.save_freq=24 \
    trainer.test_freq=18 \
    trainer.total_epochs=6 \
    custom_reward_function.path=verl/utils/reward_score/stage2.py \
    custom_reward_function.name=compute_score \
    2>&1 | tee logs/hotpotqa/${NAME}.log

export PYTHONPATH=.
python scripts/model_merger.py merge \
    --backend fsdp \
    --local_dir checkpoints/hp_bm25_step144_stage3_hard/global_step_126/actor \
    --target_dir sft_checkpoints/HP/hp_bm25_step144_stage3_hard_step126


