import torch
import torch.nn as nn


class GRU(nn.Module):
    def __init__(self, configs, feature_in, feature_out):
        super(GRU, self).__init__()
        self.feature_in = feature_in
        self.feature_out = feature_out
        self.gru = nn.GRU(input_size=self.feature_in, hidden_size=configs.d_model, batch_first=True,
                          num_layers=configs.e_layers, dropout=configs.dropout, device=configs.device)
        self.feature_project = nn.Linear(configs.d_model, self.feature_out, device=configs.device)
        self.time_project = nn.Linear(configs.seq_len, configs.pred_len, device=configs.device)

    def forward(self, x):
        # x [B, L, C]
        x, *_ = self.gru(x)  # [B, L, D]
        x = self.feature_project(x)  # [B, L, C]
        x = self.time_project(x.permute(0, 2, 1)).permute(0, 2, 1)  # [B, H, C]
        return x


class Model(nn.Module):
    def __init__(self, configs):
        super(Model, self).__init__()
        self.name = 'GRU'
        self.configs = configs
        self.seq_len = configs.seq_len
        self.pred_len = configs.pred_len
        feature_in = configs.enc_in
        feature_out = configs.c_out
        self.base_model = GRU(configs, feature_in, feature_out)

    def forecast(self, x_enc):
        dec_out = self.base_model(x_enc)
        return dec_out  # [B, H, C]

    def forward(self, x_enc, x_mark_enc=None, x_dec=None, x_mark_dec=None, target_x=None):
        dec_out = self.forecast(x_enc)
        return dec_out
