def print_args(args):
    print("\033[1m" + "Basic Config" + "\033[0m")
    print(f'  {"Model:":<20}{args.model:<20}{"Is Training:":<20}{args.is_training:<20}')
    print()

    print("\033[1m" + "Data Loader" + "\033[0m")
    print(f'  {"Data:":<20}{args.data:<20}{"Dataset Path:":<20}{args.dataset_path:<20}')
    print(f'  {"Station:":<20}{args.station:<20}{"Freq:":<20}{args.freq:<20}')
    print(f'  {"Checkpoints:":<20}{args.checkpoints:<20}{"Data Root Path:":<20}{args.data_root_path:<20}')
    print(f'  {"Target:":<20}{args.target:<20}')
    print(f'  {"Train Start Time:":<20}{args.train_start_time:<20}{"Train End Time:":<20}{args.train_end_time:<20}')
    print(f'  {"Vali Start Time:":<20}{args.vali_start_time:<20}{"Vali End Time:":<20}{args.vali_end_time:<20}')
    print(f'  {"Test Start Time:":<20}{args.test_start_time:<20}{"Test End Time:":<20}{args.test_end_time:<20}')
    print()

    print(f'  {"Seq Len:":<20}{args.seq_len:<20}{"Label Len:":<20}{args.label_len:<20}')
    print(f'  {"Pred Len:":<20}{args.pred_len:<20}{"Inverse:":<20}{args.inverse:<20}')
    print()

    print("\033[1m" + "Water Flow Parameters" + "\033[0m")
    print(f'  {"Global Alpha:":<20}{args.alpha:<20}{"Flow Factor:":<20}{args.flow_list_vali_factor:<20}')
    print(f'  {"Global loop:":<20}{args.global_loop:<20}{"Global lr:":<20}{args.global_lr:<20}')
    print(f'  {"Global lr factor:":<20}{args.global_lr_factor:<20}{"Other station:":<20}{args.other_station:<20}')
    print(f'  {"Base Flow:":<20}{args.base_flow:<20}')
    print()

    print("\033[1m" + "Model Parameters" + "\033[0m")
    print(f'  {"Num Kernels:":<20}{args.num_kernels:<20}{"d model:":<20}{args.d_model:<20}')
    print(f'  {"n heads:":<20}{args.n_heads:<20}{"e layers:":<20}{args.e_layers:<20}')
    print(f'  {"d layers:":<20}{args.d_layers:<20}{"d FF:":<20}{args.d_ff:<20}')
    print(f'  {"Moving Avg:":<20}{args.moving_avg:<20}{"Factor:":<20}{args.factor:<20}')
    print(f'  {"Distil:":<20}{args.distil:<20}{"Dropout:":<20}{args.dropout:<20}')
    print(f'  {"Embed:":<20}{args.embed:<20}{"Activation:":<20}{args.activation:<20}')
    print()

    print("\033[1m" + "Run Parameters" + "\033[0m")
    print(f'  {"Num Workers:":<20}{args.num_workers:<20}{"Itr:":<20}{args.itr:<20}')
    print(f'  {"Train Epochs:":<20}{args.train_epochs:<20}{"Batch Size:":<20}{args.batch_size:<20}')
    print(f'  {"Patience:":<20}{args.patience:<20}{"Learning Rate:":<20}{args.learning_rate:<20}')
    print(f'  {"Des:":<20}{args.des:<20}{"Loss:":<20}{args.loss:<20}')
    print(f'  {"Lradj:":<20}{args.lradj:<20}')
    print()

    print("\033[1m" + "GPU" + "\033[0m")
    print(f'  {"Use GPU:":<20}{args.use_gpu:<20}{"GPU:":<20}{args.gpu:<20}')
    print(f'  {"Use Multi GPU:":<20}{args.use_multi_gpu:<20}{"Devices:":<20}{args.devices:<20}')
    print()
