import torch
import torch.nn as nn
from layers.StandardNorm import myNormalize


class Model(nn.Module):
    def __init__(self, configs):
        super(Model, self).__init__()
        self.seq_len = configs.seq_len
        self.pred_len = configs.pred_len
        self.channels = configs.enc_in

        self.Linear = nn.Linear(self.channels * self.seq_len, self.pred_len)
        self.Linear.weight = nn.Parameter((1 / (self.channels * self.seq_len)) * torch.ones([self.pred_len, self.channels * self.seq_len]))
        self.instance_norm = myNormalize(self.channels, affine=True, subtract_last=True)

    def encoder(self, x):
        x = x.permute(0, 2, 1)
        x_out = self.Linear(x)
        x_out = x_out.permute(0, 2, 1)
        return x_out

    def forward(self, x_enc, x_enc_mark=None, x_dec=None, x_dec_mark=None, target_x=None):
        x_enc = self.instance_norm(x_enc, target_x, 'norm')
        x_enc = x_enc.reshape(x_enc.shape[0], x_enc.shape[1] * x_enc.shape[2], 1)
        dec_out = self.encoder(x_enc)
        dec_out = self.instance_norm(dec_out, mode='denorm')
        return dec_out[:, -self.pred_len:, :]  # [B, L, D]
