import torch
import torch.nn as nn


class Model(nn.Module):
    def __init__(self, configs, num_stations):
        super(Model, self).__init__()
        self.seq_len = configs.seq_len
        self.Linear = nn.Linear(num_stations * self.seq_len, self.seq_len)

    def encoder(self, x):
        x = x.permute(0, 2, 1)
        x = self.Linear(x)
        return x.permute(0, 2, 1)

    def forward(self, x_inputs, target_x=None):
        x = torch.cat(x_inputs, dim=1)
        dec_out = self.encoder(x)
        return dec_out  # [B, L, D]
