import torch
import torch.nn as nn
from layers.StandardNorm import myNormalize


class Model(nn.Module):
    def __init__(self, configs):
        super(Model, self).__init__()
        self.seq_len = configs.seq_len
        self.pred_len = configs.pred_len
        self.num_features = configs.enc_in
        self.Linear = nn.Linear(self.seq_len, self.pred_len)
        self.instance_norm = myNormalize(self.num_features, affine=True, subtract_last=True)

    def encoder(self, x):
        x = x.permute(0, 2, 1)
        x = self.Linear(x)
        return x.permute(0, 2, 1)

    def forward(self, x_enc, x_enc_mark=None, x_dec=None, x_dec_mark=None, target_x=None):
        x_enc = self.instance_norm(x_enc, target_x, 'norm')

        dec_out = self.encoder(x_enc)

        dec_out = self.instance_norm(dec_out, mode='denorm')
        return dec_out[:, -self.pred_len:, :]  # [B, L, D]
