# TrajEctory matching with Soft Label Assignment (TESLA)

# Reproduce

## Environment

First of all, make sure you have conda installed. The steps can be found here:
https://conda.io/projects/conda/en/latest/user-guide/install/index.html

Secondly, run the following command to install the environments:
conda env create -f requirements_11_3.yml

## Generate expert training trajectories

Run the following commands to generate expert training trajectories for ImageNet
python buffer.py --dataset=ImageNet --model=ConvNetD4 --train_epochs=50 --num_experts=100 --save_interval=1

For other datasets, just replace the dataset and model

## Distill synthetic dataset

One example command to distill syntheic images on ImageNet is as follows:
python distill.py --dataset=ImageNet --ipc=50 --syn_steps=20 --expert_epochs=3 --max_start_epoch=10 --lr_img=10000 --lr_lr=1e-04 --lr_teacher=0.01 --batch_syn=400 --num_eval=5 --teacher_label --model=ConvNetD4

For specific hyperparameters for a dataset, please refer to our paper appendix.


## Datasets
Note, we use CIFAR-10/100 and ImageNet-1K in our paper. CIFAR-10/100 are included in PyTorch. 
For ImageNet, please follow the instructions here to set it up: https://image-net.org/index.php
Note: you may need to resize the ImageNet to 64 * 64 which is used in our experiments.

After ImageNet is set up, please update the utils.py with your ImageNet path in the get_dataset function.


## WanDB
We upload all the training statistics to WanDB for a better visualization.