## Introduction

We propose a prototypical network with a Bayesian learning-driven contrastive loss (BLCL)
tailored specifically for class-incremental learning scenarios. Therefore,
we introduce a contrastive loss that incorporates new classes into the
latent representation by reducing the intra-class distance and increasing
the inter-class distance. Our approach dynamically adapts the balance
between the cross-entropy and contrastive loss functions with a Bayesian
learning technique.Empirical evaluations conducted on both the CIFAR-10 
dataset for image classification and images of a GNSS-based dataset
for interference classification validate the efficacy of our method, 
showcasing its superiority over existing state-of-the-art approaches.

## Methods Reproduced
-  BLCl: Bayesian Learning-driven Prototypical Contrastive Loss for Class-Incremental Learning
-  FineTune: Baseline method which simply updates parameters on new tasks.
-  EWC: Overcoming catastrophic forgetting in neural networks. 
-  LwF:  Learning without Forgetting. 
-  Replay: Baseline method with exemplar replay.
-  iCaRL: Incremental Classifier and Representation Learning. 
-  MEMO: A Model or 603 Exemplars: Towards Memory-Efficient Class-Incremental Learning.


### Dependencies

1. torch 1.81
2. torchvision 0.6.0
3. tqdm
4. numpy
5. scipy
6. Tensorboard

### Run experiment

1. Run: python main.py --config=./exps/blcl.json 
                       --dataset=cifar10
                       --sumarry_file=CIFAR10_BLCL8_1234  
                       --layers=[[2,2],[2,1],[1,1],[2],[1]] 
                       --type=normal
                       --convnet_type=memo_resnet56

2. Edit the '[MODEL NAME].json' file for global settings.
3. Edit the hyperparameters in the corresponding '[MODEL NAME].py' file (e.g., 'models/icarl.py').
4. --layers = BLCL specialized blocks (BLCL_[1234] corresponds to [[2,2],[2,1],[1,1],[2],[1]])
5. --dataset = GNSS or cifar10
6. --type = whether to average the specialized blocks ("avg" if yes, "normal" if no)
7. --convnet_type = Type of Resnet block (memo_resnet18, memo_resnet32, memo_resnet44, memo_resnet56)


### Datasets

We have implemented the pre-processing of 'GNSS' and 'CIFAR10'.
When training on 'CIFAR10', this framework will automatically download it. 


### Evaluation

1. cluster_analysis.py 
    - Performs cluster analysis using embeddings and ground truth labels and calculated the Davies-Bouldin and Calinski-Harabasz score.
2. tsne.py 
    - performs t-SNE on the dataset in the NxD array to reduce its dimensionality to required dimensions.
