import json
import argparse
from trainer import train
import json

def string_to_list(args):
    return json.loads(args)

def main():
    args = setup_parser().parse_args()
    param = load_json(args.config)
    args = vars(args)  # Converting argparse Namespace to a dict.
    args.update(param)  # Add parameters from json
    train(args)

def load_json(settings_path):
    with open(settings_path) as data_file:
        param = json.load(data_file)
    return param

def setup_parser():
    parser = argparse.ArgumentParser(description='Reproduce of multiple continual learning algorthms.')
    parser.add_argument('--config', type=str, default='./exps/finetune.json', help='Json file of settings.')
    parser.add_argument('--dataset', default="gnss", help="Kind of dataset",  type=str)
    parser.add_argument('--summary_file', type=str, default='run_new',help='path for the tensorboard experiment')
    parser.add_argument('--layers', help='delimited list input',  type=string_to_list)
    parser.add_argument('--type', default="normal", help='Type of memo models (normal or avg)',  type=str)
    parser.add_argument('--convnet_type', default="memo_resnet32", help="Kind of resnet",  type=str)
    return parser

if __name__ == '__main__':
    main()
