mkdir -p tmp ; cd tmp
BASE_PATH=..
LAUNCH="srun -p llm-safety --quotatype=${QUOTATYPE:-auto} --gres=gpu:${GPU:-1} --cpus-per-task=8 --async"

world_size=64
model_name=meta-llama/Llama-2-7b-chat-hf
scorer_name=tulu-2-dpo-7b
base_output_path=${BASE_PATH}/output/alpaca_leaderboard/${model_name}/${scorer_name}-guidance

# beta 1.0 1.5
for beta in 0.25 0.5 1.0 1.5; do
    for rank in $(seq 0 $((world_size-1))); do
        output_path=${base_output_path}/eft/beta${beta}/gen
        if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
        echo "rank ${rank}/${world_size}"
        PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/alpaca_leaderboard/gen_eft.py \
            --model_name=${model_name} \
            --scorer_name=${scorer_name} \
            --output_path=${output_path} \
            --generation_configs.beta=${beta} \
            --rank=${rank} \
            --world_size=${world_size} &
        sleep .5
    done
done

cd ..
