mkdir -p tmp ; cd tmp
BASE_PATH=..
LAUNCH="srun -p llm-safety --quotatype=${QUOTATYPE:-reserved} --gres=gpu:0 --cpus-per-task=8 --async"

world_size=8
model_name=openai/gpt-3.5-turbo-instruct
base_output_path=${BASE_PATH}/output/alpaca_leaderboard/${model_name}

for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/base/b1/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/alpaca_leaderboard/sh/openai/gpt-3.5-turbo-instruct/gen_base.py \
        --model_name=${model_name} \
        --output_path=${output_path} \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done

cd ..
