mkdir -p tmp ; cd tmp
BASE_PATH=..
LAUNCH="srun -p llm-safety --quotatype=${QUOTATYPE:-auto} --gres=gpu:1 --cpus-per-task=8 --async"

world_size=32
model_name=openai-community/gpt2-xl
base_output_path=${BASE_PATH}/output/summarize_from_feedback/${model_name}

# n16
for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/bon/n16/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/summarize_from_feedback/gen_bt.py \
        --model_name=${model_name} \
        --output_path=${output_path} \
        --generation_configs.beta=1.0 \
        --generation_configs.num_beams=1 \
        --generation_configs.num_candidates=16 \
        --generation_configs.block_len=10000000 \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done

# n4
for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/bon/n4/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/summarize_from_feedback/gen_bt.py \
        --model_name=${model_name} \
        --output_path=${output_path} \
        --generation_configs.beta=1.0 \
        --generation_configs.num_beams=1 \
        --generation_configs.num_candidates=4 \
        --generation_configs.block_len=10000000 \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done

cd ..
