mkdir -p tmp ; cd tmp
BASE_PATH=..
LAUNCH="srun -p llm-safety --quotatype=${QUOTATYPE:-auto} --gres=gpu:${GPU:-4} --cpus-per-task=16 --async"

world_size=64
model_name=meta-llama/Meta-Llama-3-70B-Instruct
scorer_name=zephyr-7b-beta
base_output_path=${BASE_PATH}/output/alpaca_leaderboard/${model_name}/${scorer_name}-guidance

for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/bon/n4/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/alpaca_leaderboard/gen_bt.py \
        --model_name=${model_name} \
        --scorer_name=${scorer_name} \
        --output_path=${output_path} \
        --generation_configs.temperature=0.6 \
        --generation_configs.top_p=0.9 \
        --generation_configs.beta=1.0 \
        --generation_configs.num_beams=1 \
        --generation_configs.num_candidates=4 \
        --generation_configs.block_len=10000000 \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done

cd ..
