mkdir -p tmp ; cd tmp
BASE_PATH=..
LAUNCH="srun -p llm-safety --quotatype=${QUOTATYPE:-auto} --gres=gpu:1 --cpus-per-task=8 --async"

declare -A model_name_2_path
model_name_2_path[gpt2-dpo]=/mnt/petrelfs/share_data/llm-safety/models/gpt2-imdb-dpo
model_name_2_path[gpt2-sft]=/mnt/petrelfs/share_data/llm-safety/models/gpt2-imdb
model_name_2_path[gpt2-large]=/mnt/petrelfs/share_data/llm-safety/models/ft_models/DPO_gpt2-large-imdb_imdb_token_DPO_1e-5_5e-5
model_name_2_path[gpt2-xl]=/mnt/petrelfs/share_data/llm-safety/models/ft_models/DPO_gpt2-xl-imdb_imdb_token_DPO_1e-5_5e-5
model_name_2_path[Llama-2-7b-hf]=/mnt/petrelfs/share_data/llm-safety/models/ft_models/DPO_llama-2-7b-imdb_imdb_token_DPO_1e-5_5e-5
model_name_2_path[Meta-Llama-3-8B]=/mnt/petrelfs/share_data/llm-safety/models/ft_models/DPO_llama-3-8b-imdb_imdb_token_DPO_1e-5_5e-5

world_size=16
base_output_path=${BASE_PATH}/output/imdb/others

for model_name in "${!model_name_2_path[@]}"; do

    model_path=${model_name_2_path[$model_name]}

    for rank in $(seq 0 $((world_size-1))); do
        output_path=${base_output_path}/${model_name}/gen
        if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
        echo "rank ${rank}/${world_size}"
        PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/imdb/gen_tune.py \
            --model_name=${model_path} \
            --output_path=${output_path} \
            --rank=${rank} \
            --world_size=${world_size} &
        sleep .5
    done

done

cd ..
