mkdir -p tmp ; cd tmp
BASE_PATH=..
LAUNCH="srun -p llm-safety --quotatype=${QUOTATYPE:-auto} --gres=gpu:1 --cpus-per-task=8 --async"

world_size=16
model_name=openai-community/gpt2-large
base_output_path=${BASE_PATH}/output/imdb/${model_name}

# b4c4l5
for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/bt/positive/b4c4l5/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "positive, rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/imdb/gen_bt.py \
        --model_name=${model_name} \
        --output_path=${output_path} \
        --generation_configs.beta=1.0 \
        --generation_configs.num_beams=4 \
        --generation_configs.num_candidates=4 \
        --generation_configs.block_len=5 \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done
for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/bt/negative/b4c4l5/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "negative, rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/imdb/gen_bt.py \
        --model_name=${model_name} \
        --output_path=${output_path} \
        --generation_configs.beta=-1.0 \
        --generation_configs.num_beams=4 \
        --generation_configs.num_candidates=4 \
        --generation_configs.block_len=5 \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done

# b2c2l5
for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/bt/positive/b2c2l5/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "positive, rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/imdb/gen_bt.py \
        --model_name=${model_name} \
        --output_path=${output_path} \
        --generation_configs.beta=1.0 \
        --generation_configs.num_beams=2 \
        --generation_configs.num_candidates=2 \
        --generation_configs.block_len=5 \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done
for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/bt/negative/b2c2l5/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "negative, rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/imdb/gen_bt.py \
        --model_name=${model_name} \
        --output_path=${output_path} \
        --generation_configs.beta=-1.0 \
        --generation_configs.num_beams=2 \
        --generation_configs.num_candidates=2 \
        --generation_configs.block_len=5 \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done

cd ..
