mkdir -p tmp ; cd tmp
BASE_PATH=..
LAUNCH="srun -p llm-safety --quotatype=${QUOTATYPE:-auto} --gres=gpu:1 --cpus-per-task=8 --async"

world_size=16
model_name=openai-community/gpt2-medium
base_output_path=${BASE_PATH}/output/imdb/${model_name}

for beta in 0.25 0.5 1.0 2.0 4.0; do
    for rank in $(seq 0 $((world_size-1))); do
        output_path=${base_output_path}/eft/positive/beta${beta}/gen
        if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
        echo "positive, beta ${beta}, rank ${rank}/${world_size}"
        PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/imdb/gen_eft.py \
            --model_name=${model_name} \
            --output_path=${output_path} \
            --generation_configs.beta=${beta} \
            --rank=${rank} \
            --world_size=${world_size} &
        sleep .5
    done
done

for beta in -0.25 -0.5 -1.0 -2.0 -4.0; do
    for rank in $(seq 0 $((world_size-1))); do
        output_path=${base_output_path}/eft/negative/beta${beta}/gen
        if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
        echo "negative, beta ${beta}, rank ${rank}/${world_size}"
        PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/imdb/gen_eft.py \
            --model_name=${model_name} \
            --output_path=${output_path} \
            --generation_configs.beta=${beta} \
            --rank=${rank} \
            --world_size=${world_size} &
        sleep .5
    done
done

cd ..
