# pylint: disable = line-too-long

import spot


def check_inclusion(formula_str, trace_str):
    formula_spot = spot.formula(formula_str)
    trace_spot = spot.parse_word(trace_str)
    formula_automaton = formula_spot.translate()
    trace_automaton = trace_spot.as_automaton()
    try:
        return spot.contains(formula_automaton, trace_automaton) # spot.contains checks whether language of its right argument is included in language of its left argument
    except RuntimeError:
        return None


def get_trace(formula_str, simplify):
    spot_formula = spot.formula(formula_str)
    automaton = spot_formula.translate()
    automaton.merge_edges()
    acc_run = automaton.accepting_run()
    if acc_run is None:
        return False, None
    else:
        trace = spot.twa_word(acc_run)
        if simplify:
            trace.simplify()
        return True, str(trace)