# This repository
This repository contains the code for the paper

Fast, Expressive $\mathrm{SE}(n)$ Equivariant Networks through Weight-Sharing in Position-Orientation Space

# Conda environment
In order to run the code in this repository install the following conda environment
Conda env
```
conda create --yes --name ponita python=3.10 numpy scipy matplotlib
conda activate ponita
conda install pytorch==1.13.1 torchvision==0.14.1 torchaudio==0.13.1 pytorch-cuda=11.7 -c pytorch -c nvidia -y
conda install pyg==2.2.0 -c pyg -y
pip3 install wandb
pip3 install pytorch_lightning==1.8.6
```

# Main files
By the camera ready submission time we will have completely cleaned up the repositry, including the EDM experiments as well, all in the same standardized workflow based on PyTorch Lightning.

Currently, the rmd17` and n-body experiments are run with the files ```main.py``` and ```main_nbody.py``` respectively. The diffusion experiments are still to be added, and are based on [this repository](https://github.com/ehoogeboom/e3_diffusion_for_molecules). To run main_nbody.py one first has to generate the dataset, see the [original EGNN repo](https://github.com/vgsatorras/egnn/blob/main/main_nbody.py) for details. We are deeply grateful for the EGNN authors to make their code available in public repositories. We will do so the same with this repository upon acceptance, as to hopefully benefit other DL researchers as pracitioners in the field.

The model used in the experiment are given ```models/siva_fiber.py``` and ```models/siva_nbody.py``` for the rMD17 and n-body experiments respectively. The PytorchLightning wrappers are given in ```models/md17.py``` and ```models/nbody.py```. The main layer ```FiberConvNextBlock``` is given in ```siva/nn/layers/convnext.py```. The attribute embedding function is given in ```siva/invariants/r3s2.py```.

# The Siva Library
# :hand: siva :trident:
When developing the PONITA method, we were working on a general library for computing invariant attributes. For the purpose of simplicity we may turn this into a separate library and only keep the relevant R3 and R3S2 invariants in this repository, such that this repository can lean and mean.

**S**E(d) **I**nvariant **V**ector **A**ttributes (:hand: **SIVA** :trident:) of tuples of points in the homogeous spaces $M=\mathbb{R}^d$, $M=\mathbb{R}^d \times S^{d-1}$, or $M=SE(d)$. We consider the cases $d=2$ and $d=3$. The library thus allows for the computation of invariant attributes between tuples of points in
* **Position space** $\mathbb{R}^2$ and $\mathbb{R}^3$ ,
* **Position-Orientation space** $\mathbb{R}^2 \times S^1 \equiv SE(2)$ and $\mathbb{R}^3 \times S^2$ ,
* **Groups** $SE(2)$ and $SE(3)$ .
