from setuptools import setup, find_packages
from pathlib import Path

def read_requirements(path="requirements.txt"):
    reqs = []
    for line in Path(path).read_text().splitlines():
        line = line.strip()
        if not line or line.startswith("#") or line.startswith(("-", "--")):
            continue
        reqs.append(line)
    return reqs

setup(
    name="AprxEquiRL_mujoco",
    description="",
    version="0.0",
    author="-",
    license="MIT",
    python_requires="~=3.9",
    install_requires=read_requirements()
        + ['olive-oil-ml @ git+https://github.com/mfinzi/olive-oil-ml',
      'emlp @ git+https://github.com/mfinzi/equivariant-MLP'],
    packages=find_packages(include=["aerl"]),
    long_description=open("README.md").read(),
)