#!/bin/bash

# a little bit hacky, but to avoid combinatorial explosion in JSONs while being able to adjust config params,
# the lines below set the reward_threshold to be 'mean'. After the scripts are executed, the jsons are reverted back to original.
# we do the same when adjusting k. 
# that is, the verifier jsons use 0.5 reward_threshold and k=1 as default (for one_stage).
# comment below and end of script to use default setting.
JSON_DIR="verifier_JSONs/"
: 'find "$JSON_DIR" -type f -name "*.json" | while read -r file; do
    jq 'if .global_params.reward_threshold? then .global_params.reward_threshold = "mean_per_problem" else . end' "$file" > temp.json && mv temp.json "$file"
done
'


: 'find "$JSON_DIR" -type f -name "*.json" | while read -r file; do
    # Update filter_strategy_param if filter_strategy is "top_k"
    jq 'if .verifiers[0].params.filter_strategy? == "top_k" then .verifiers[0].params.filter_strategy_param = 50 else . end' "$file" > temp.json && mv temp.json "$file"

    echo "Updated: $file"
done'


DATASET="anonymous_research/MATH_with_RM_LJ_UT_v1"


# Function to run `main.py` with --redo
run_main() {
    python main.py --dataset "$DATASET" --config "$1" --redo
}

# Unsupervised Approaches
run_main verifier_JSONs/one_stage/unsupervised/First_Sample.json
run_main verifier_JSONs/one_stage/unsupervised/Majority_Vote_Best_Tied.json
run_main verifier_JSONs/one_stage/unsupervised/Majority_Vote_Top_1.json
run_main verifier_JSONs/one_stage/unsupervised/Naive_Judge_Ensemble_Best_Tied.json
run_main verifier_JSONs/one_stage/unsupervised/Naive_Judge_Ensemble_Top_1.json
run_main verifier_JSONs/one_stage/unsupervised/Naive_RM_Ensemble_Best_Tied.json
run_main verifier_JSONs/one_stage/unsupervised/Naive_RM_Ensemble_Top_1.json

# Supervised Approaches
run_main verifier_JSONs/one_stage/supervised/Normalized_Precision_Ensemble.json
run_main verifier_JSONs/one_stage/supervised/Normalized_Recall_Ensemble.json
run_main verifier_JSONs/one_stage/supervised/Prediction_Accuracy_Ensemble.json
run_main verifier_JSONs/one_stage/supervised/Selection_Accuracy_Ensemble.json
run_main verifier_JSONs/one_stage/supervised/Top_Judges_Best_Tied.json
run_main verifier_JSONs/one_stage/supervised/Top_Judges_Top_1.json
run_main verifier_JSONs/one_stage/supervised/Top_RMs_Best_Tied.json
run_main verifier_JSONs/one_stage/supervised/Top_RMs_Top_1.json

# Weak Supervision Approaches
run_main verifier_JSONs/one_stage/ws/Weak_Supervision_Prediction_Accuracy.json
run_main verifier_JSONs/one_stage/ws/Weak_Supervision_Scores_Best_Tied.json
run_main verifier_JSONs/one_stage/ws/Weak_Supervision_Scores_Top_1.json


# Restore reward_threshold to 0.5 *only if it exists* under global_params
find "$JSON_DIR" -type f -name "*.json" | while read -r file; do
    jq 'if .global_params.reward_threshold? then .global_params.reward_threshold = 0.5 else . end' "$file" > temp.json && mv temp.json "$file"
done


find "$JSON_DIR" -type f -name "*.json" | while read -r file; do
    # Update filter_strategy_param if filter_strategy is "top_k"
    jq 'if .verifiers[0].params.filter_strategy? == "top_k" then .verifiers[0].params.filter_strategy_param = 1 else . end' "$file" > temp.json && mv temp.json "$file"
done




