import torchmetrics
import torch
from tqdm import tqdm
def GNNNodeEva(data, idx_test,  gnn, answering, num_class, device):
    gnn.eval()
    accuracy = torchmetrics.classification.Accuracy(task="multiclass", num_classes=num_class).to(device)
    macro_f1 = torchmetrics.classification.F1Score(task="multiclass", num_classes=num_class, average="macro").to(device)
    auroc = torchmetrics.classification.AUROC(task="multiclass", num_classes=num_class).to(device)
    auprc = torchmetrics.classification.AveragePrecision(task="multiclass", num_classes=num_class).to(device)
    criterion = torch.nn.CrossEntropyLoss()

    accuracy.reset()
    macro_f1.reset()
    auroc.reset()
    auprc.reset()

    out = gnn(data.x, data.edge_index, batch=None)
    out = answering(out)
    loss = criterion(out[idx_test], data.y[idx_test])
    pred = out.argmax(dim=1) 

    acc = accuracy(pred[idx_test], data.y[idx_test])
    return acc.item(), loss.item(), out[idx_test], data.y[idx_test]
