import argparse

def get_args():
    parser = argparse.ArgumentParser(description='Implementation of DP-GPL')
    parser.add_argument('--task', type = str)
    parser.add_argument('--dataset_name', type=str, default='Cora',help='Choose the dataset')
    parser.add_argument('--device', type=int, default=0,
                        help='Which gpu to use if any (default: 0)')
    parser.add_argument('--gnn_type', type=str, default="GCN", help='We support GCN, GAT, GraphTransformer')
    parser.add_argument('--prompt_type', type=str, default="None", 
                        help='Choose the prompt type (All-in-one, GPPT, GPF-plus)')   
    parser.add_argument('--hid_dim', type=int, default=128,
                        help='hideen layer of GNN dimensions (default: 128)')
    parser.add_argument('--batch_size', type=int, default=128,
                        help='Input batch size for training (default: 128)')
    parser.add_argument('--epochs', type=int, default=300,
                        help='Number of epochs to train (default: 50)')
    parser.add_argument('--shot_num', type=int, default = 1, help='Number of shots')
    parser.add_argument('--pre_train_model_path', type=str, default='None', 
                        help='add pre_train_model_path for graph prompt learning.')
    parser.add_argument('--lr', type=float, default=0.001,
                        help='Learning rate (default: 0.001)')
    parser.add_argument('--decay', type=float, default=0,
                        help='Weight decay (default: 0)')
    parser.add_argument('--num_layer', type=int, default=3,
                        help='Number of GNN message passing layers (default: 3).')
    parser.add_argument('--dropout_ratio', type=float, default=0.5,
                        help='Dropout ratio (default: 0.5)')
    parser.add_argument('--graph_pooling', type=str, default="mean",
                        help='Graph level pooling (sum, mean, max, set2set, attention)')
    parser.add_argument('--JK', type=str, default="last",
                        help='How the node features across layers are combined. last, sum, max or concat')
    parser.add_argument('--seed', type=int, default=42, help = "Seed for reproducing.")
    parser.add_argument('--num_workers', type=int, default = 0, help='Number of workers for dataset loading')
    parser.add_argument('--num_layers', type=int, default = 1, help='A range of [1,2,3]-layer MLPs with equal width')
    parser.add_argument('--pnum', type=int, default = 5, help='The number of independent basis for GPF-plus')
    parser.add_argument('--pre_train_data', type=str, default='Cora',help='Choose the dataset of pretrain task')
    parser.add_argument('--pre_train_type', type=str, default='SimGRACE',help='Choose the pretrain strategy')
    
    # parameters for DP-SGD
    parser.add_argument('--dpsgd', action="store_true", help="wheterh to use DP-SGD in training")
    parser.add_argument('--eps', type=float, default=1, help='eps for DPSGD')
    parser.add_argument('--sample_rate', type=float, default=0.6, help='sample rate for DPSGD')

    # parameters for DP-GPL
    parser.add_argument('--number_of_teachers', type=int, default=200, help='Number of teacher prompts')
    parser.add_argument('--pate', action="store_true", help="whether to use DP-DGL")

    # parameters for pate inference
    parser.add_argument('--threshold', type=int, default=150, help='')
    parser.add_argument('--sigma_threshold', type=int, default=50, help='')
    parser.add_argument('--sigma_gnmax', type=int, default=5, help='')
    parser.add_argument('--delta', type=float, default=1e-7, help='delta for DPSGD & PATE')

    # parameters for student prompt training
    parser.add_argument('--student_prompt', action="store_true", help="whether to fine tune student prompt")

    # parameters for DP-GPL+W
    parser.add_argument('--weighted_pate', action="store_true", help="whether to use DP-DGL-W")
    args = parser.parse_args()
    return args
