# Localized Graph Contrastive Learning

### Requirements

- Python version: 3.7.10
- Pytorch version: 1.10.2
- DGL version: 0.7.1
To enable SORF for fast kernel proximation, make sure the gpu is enabled and 'hadamard_cuda' can successfully load the cpp extensions.

check https://github.com/HazyResearch/structured-nets for details.

### Hyperparameters
Following Options can be passed to `main.py`

`--dataname:`
Name of the dataset. Supported names are: cora, citeseer, pubmed, comp, photo, cs, and physics. Default is cora.  
usage example :`--dataname cora`

`--use_mlp:`
Whether to use Multi-Layer Perceptrons as the encoder (instead of GCN) or not. Default is False.  
usage example :`--use_mlp`

`--loss:`
The loss approximation method. Supported names are: infonce, rff, sorf. Default is sorf.  
usage example :`--loss sorf`

`--epochs:`
The number of training epochs. Default is 50.  
usage example :`--epochs 50`

`--lr1:`
The learning rate of Local-GCL. Default is 5e-4.  
usage example :`--lr1 5e-4`

`--lr2:`
The learning rate of logistic regression. Default is 1e-2.  
usage example :`--lr2 1e-2`

`--wd1:`
The weight decay of Local-GCL. Default is 1e-6.  
usage example :`--wd1 1e-6`

`--wd2:`
The weight decay of logistic regression. Default is 1e-5.  
usage example :`--wd2 1e-5`

`--n_layers:`
The number of layers of the encoder. Default is 2.  
usage example :`--n_layers 2`

`--hid_dim:`
The number of hidden units of each layer. Default is 2048.  
usage example :`--hid_dim 2048`

`--rff_dim:`
The number of random features (i.e, the projection dimension). Default is 8192.  
usage example :`--rff_dim 8192`

`--temp:`
The temperature hyperparameter. Default is 0.5.  
usage example :`--temp 0.5`

### How to Run

You can run the model with following option
- To run node classification (reproduce Table 3 in paper)
```
sh run.sh
```
