## CODE ACCOMPANIED THE PAPER "Does a sparse ReLU network training problem always admit an optimum ?"
### Code organisation 
```
├── quantifiersElimination      # Code for Section 3.3
│   ├── LU2x2.py                # Z3Prover code for 2 x 2 LU architecture
│   ├── LU3x3.py                # Z3Prover code for 3 x 3 LU architecture
│   ├── fullsupport.py          # Z3Prover code for 2 x 2 plain support
│   ├── randomized_support.py   # Code to answer Question 3.2 and produce Figure 2 
├── regularizationImpact        # Code for Section 3.2
│   ├── training.py             # Training in Example 3.1
│   ├── data_generate.py        
│   ├── models.py
│   ├── plot_err.py             # Code to plot the training curves 
├── requirements.txt
├── README.md
```

### How to run the code
To run the code in Example 3.1.
```
cd regularizationImpact   
python training.py              # Can be skipped if the results are available already available
python plot_err.py
```

To run the code in Section 3.3.
```
cd quantifiersElimination 
```
```
python LU2x2.py                 # Run algorithm in Lemma 3.3 with LU architecture of size 2 x 2
```
```
python LU3x3.py                 # Run algorithm in Lemma 3.3 with LU architecture of size 3 x 3
```
```
python fullsupport.py           # Run algorithm in Lemma 3.3 with dense architecture of size 2 x 2
```
```
python randomized_support.py    # Run code to answer Question 3.2 and produce Figure 2 
```