# Asynchronous Graph Generator
## Init repository
to replicate the `conda` environment used for this code run
~~~console
conda env create -f environment.yaml
~~~
You'll need to set up a local mongoDB to store all the pre-processing for rapid read-write. Once you've set that up the
mongoDB config file can be found in the datareader paths e.g. `Datasets/Beijing/data/mongo_config.yaml`

config files take the form
~~~yaml
data_root: <data base root>
base: 'Activity'
host: '127.0.0.1'
port: 27017
~~~
## Run training
To train interpolation models
~~~console
python train_activity.py -c ./activity_config.yaml
~~~
all hyperparameters should be changed in the corresponding `activity_config.yaml`
schema file.

Similarly, for the __PM2.5__ dataset (Beijing) with the run file names `train_kdd_interpolation.py` and the corresponding config file
called `kdd_config.yaml`

And for Physio net use `train_icu_interpolation.py` and the config `icu_config.yaml
