# Experiments on Facial Attributes Recognition E6 (A.1)
New Experiments E7, presented in supplementry materialls at A.11

## Dataset:    
 - Dataset `CelebAMask-HQ` needs to be downloaded from [https://github.com/switchablenorms/CelebAMask-HQ](https://github.com/switchablenorms/CelebAMask-HQ).

# Model Setting:

1. Model with trained weights needed to download is provided by `kartikbatra` and publicaly [available here](https://www.kaggle.com/code/kartikbatra/multilabelclassification/notebook).
2. Make sure to download it and place it at [/models/model.pth](/models/model.pth)

# Folder Structure

1. Main folder `CelebA_experiments` contains notebooks and results folder.

2. Results folder contains further following folders:
    - Folders:
        - csv: folder contains [csv files](results/csv/) which are computed by Notebook: [`notebooks/CelebA_experiments/N1_Run_experiments_CelebA.ipynb`](`notebooks/CelebA_experiments/2_Run_experiments_CelebA.ipynb`) using different background replacement setup.
        - boxplots :   this folder contains pre-computed results presented in paper as `Figure 18`.
        - selected: This folder will contain the partial results used to generate the `Figure 17` of the paper.
    - Files: HTML-Files reporting visual analysis of computed explanations by various XAI methods.

## Notebooks 
Notebooks are available at `notebooks/CelebA_experiments/`

### Compute Explanations and CSV Files:
1. To run single selected examples, run untill `Cell #55` of [`notebooks/CelebA_experiments/N1_Run_experiments_CelebA.ipynb`](`notebooks/CelebA_experiments/2_Run_experiments_CelebA.ipynb`).
2. To run full test set for a specific background replacement values, select `background_type`, and also by flipping the boolean variable `run_full_test` of [`notebooks/CelebA_experiments/N1_Run_experiments_CelebA.ipynb`](`notebooks/CelebA_experiments/2_Run_experiments_CelebA.ipynb`)
3. To run full ablation analysis on CelebA dataset using multiple background replacement values, flip boolean variable `run_ablation_analysis`  which will take almost 10 hours and will compute explanations and csv for all the background replacement values (i.e 'black' , 'white' , 'gray' , 'noise'  , 'full', 'blurred').

### Compute Results from Computed CSV and explanations:
1. To draw boxplots presented in supplementry material figures using [CSV files](results/csv/), run [`notebooks/CelebA_experiments/N2_DrawPlot_from_CSV.ipynb`](`notebooks/CelebA_experiments/N3_DrawPlot_from_CSV.ipynb`) by selecting the specific `background replacement value` and it will save the generated Boxplot at [Boxlpts Folder](results/boxplots/). (i.e. [Boxplot usiing blurred bg](results/boxplots/results_table_IoU_110_10_blurred.pdf))

3. All computed heatmap expalanations and IoU plots are combined togather as to generate HTML files to perform visual analysis run [`notebooks/CelebA_experiments/N3_Create_HTML_File.ipynb`](`notebooks/CelebA_experiments/N3_DrawPlot_from_CSV.ipynb`) which will generate [HTML Files for heatmaps](results/HTML_CelebA_blurred.html) & [HTML Files for IoU](results/HTML_CelebA_blurred_IoU.html) by loading the computed expalantions [`heatmaps~`](results/bg_blurred/) and by loading computed [CSV files](results/csv/csv_expIoU_face_116_10_blurred.csv).



## Example:
<div>
    <table>
    <tr>
    <td style="text-align: center;"> Input</td>
    <td style="text-align: center;"> GroundTruth</td>
    <td style="text-align: center;"> BPT-100</td>
    <td style="text-align: center;"> BPT-500</td>
    <td style="text-align: center;"> BPT-1000</td>
    <td style="text-align: center;"> AA-100</td>
    <td style="text-align: center;"> AA-500</td>
    <td style="text-align: center;"> AA-1000</td>
    <td style="text-align: center;"> LIME-50</td>
    <td style="text-align: center;"> LIME-100</td>
    <td style="text-align: center;"> LIME-200</td>
    <td style="text-align: center;"> GradShap</td>
<tr>
    <td colspan="12"><img src='results/bg_gray/132_Eyeglasses_gray_heatmaps.png'></td>
<tr colspan="12">
<td colspan="12"><img src='results/bg_gray/132_Eyeglasses_gray_iou.png'></td>
</table>
<div>
