# Shapley image explanations with data-aware Binary Partition Trees
Following are the datasets that are needed to reproduce the results presented in this paper. Since we have no rights to redistribute them, you have to download them before running the experiments.

## 1. ImageNet & ImageNetS Dataset
The `ImageNet` and `ImageNet-S` datasets needed and are publicly available, and are needed for running the complete experiments. 
So make sure to download these datsets in [`imageNet`](imageNet/) and [`imageNetS`](imageNetS/) folders respectively and they are  available as follows:
- `ImageNet` dataset (Validation-set) is required which can be downloaded from [`ImageNet website`](https://www.image-net.org/)
- `ImageNetS-50` is used for the experiments which requires to be downloaded from [`this link`](https://github.com/LUSSeg/ImageNet-S?tab=readme-ov-file#get-part-of-the-imagenet-s-dataset) and they should be in the below structure. 
- https://github.com/LUSSeg/ImageNet-S/blob/main/data/categories/ImageNetS_categories_im50.txt
 ```
├── ImageNet
|   ├── ImageNet
|   |   ├── ILSVRC2012_img_val
|   |   |   ├── ILSVRC2012_val_00000001.JPEG
|   |   |   ├── ILSVRC2012_val_00000002.JPEG
|   |   |   ├── ---
|   |   |   ├── ILSVRC2012_val_00050000.JPEG
|   ├── ImageNetS
|   |   ├── ImageNetS_categories_im50.txt
|   |   ├── ImageNetS_categories_im300.txt
|   |   ├── ImageNetS_categories_im919.txt
|   |   ├── ImageNetS_im919_mapping_test.txt
|   |   ├── ImageNetS_im919_mapping_validation.txt
|   |   ├── ILSVRC2012_img_val_S
|   |   |   ├── ImageNetS50
|   |   |   ├── ImageNetS300
|   |   |   ├── ImageNetS919
|   |   |   |   ├── train-semi-segmentation
|   |   |   |   ├── validation-segmentation
|   |   |   |   |   ├── n01443537
|   |   |   |   |   |   ├── ILSVRC2012_val_00004677.png
|   |   |   |   |   |   ├── ILSVRC2012_val_00006007.png
|   |   |   |   |   |   ├── ---
|   |   |   |   |   |   ├── ILSVRC2012_val_00048864.png
|   |   |   |   |   ├── n01491361
|   |   |   |   |   ├── ----
|   |   |   |   |   ├── n12998815
 ```

 ## 2. MVTec Dataset
Another dataset used is `MVTec dataset` which needs to be downloaded from official link [`here at MVTec`](https://www.mvtec.com/company/research/datasets/mvtec-ad).
Make sure to download MVTec dataset at [`mvtec_anomaly_detection/`](mvtec_anomaly_detection/) and it should be in the below structure.

 ```
├── mvtec_anomaly_detection
|   ├── hazelnut
|   |   ├── ground_truth
|   |   |   ├── crack
|   |   |   |   ├── 000_mask.png
|   |   |   |   ├── 001_mask.png
|   |   |   ├── cut
|   |   |   ├── hole
|   |   |   ├── print
|   |   ├── train
|   |   |   ├── good
|   |   |   |   ├── 000.png
|   |   |   |   ├── 000.png
|   |   |   |   ├── ---
|   |   |   |   ├── 390.png
|   |   ├── test
|   |   |   ├── crack
|   |   |   |   ├── 000.png
|   |   |   |   ├── 000.png
|   |   |   |   ├── ---
|   |   |   |   ├── 017.png
|   |   |   ├── cut
|   |   |   ├── good
|   |   |   ├── hole
|   |   |   ├── print
|   ├── ~~
|   ├── ~~
 ```


 ## 3. Celeb-A & Celeb-A-HQ Dataset
 - Dataset `CelebAMask-HQ` needs to be downloaded from [`https://github.com/switchablenorms/CelebAMask-HQ`](https://github.com/switchablenorms/CelebAMask-HQ). Make sure to download the dataset at [`CelebA/`](CelebA/) and it should be in the below structure.

 ```
├── CelebA
|   ├── CelebAMask-HQ
|   |   ├── CelebA-HQ-img
|   |   |    ├── 0.jpg
|   |   |    ├── 1.jpg
|   |   |    ├── ----
|   |   |    ├── ----
|   |   |    ├── 29999.jpg
|   |   ├── CelebAMask-HQ-mask-anno
|   |        ├── 0
|   |        |   ├── 00000_hair.png
|   |        |   ├── 00000_l_brow.png
|   |        |   ├── 00000_l_eye.png
|   |        |   ├── ----
|   |        |   ├── ----
|   |        |   ├── ----
|   |        |   ├── 01999_skin.png
|   |        |   ├── 01999_u_lip.png
|   |        ├── 1
|   |        ├── --
|   |        ├── --
|   |        ├── 14
 ```