# PyTorch Implementation of [From Attention Maps to Prediction Maps]

This code is based on
https://github.com/hila-chefer/Transformer-Explainability


The code for our visualization method [PredicAtt](baselines/ViT/ViT_new.py#L222) can be found in:
```
baselines/ViT/ViT_new.py: VisionTransformer.predicatt()
```

A simple Jupyter notebook to demonstrate our method is attached: [predicatt_demo.ipynb](predicatt_demo.ipynb)


To reproduce experiment results:
```
export IMAGENET_SEGMENTATION_PATH="/path/to/imagenet-segmentation/gtsegs_ijcv.mat"
export IMAGENET_PATH="/path/to/imagenet/"

./scripts/run_exp_vit-b.sh
./scripts/run_exp_vit-l.sh

./scripts/run_exp_ablations.sh
./scripts/run_exp_per_layer.sh
```

To benchmark resource consumption (runtime and GPU memory):
```
./scripts/run_benchmark_resources
```
